---
title: Docs for Agent（Coding Agent 使用说明）
---

# Docs for Agent（Coding Agent 使用说明）

如果你希望让 **Codex / Claude Code** 这类 Coding Agent 正确使用 Agently 文档与示例，请按下列步骤操作。

---

## 1. 下载 Agent 文档包

- 在线下载：[/docs/agent_docs.zip](/agent_docs.zip)

解压后结构（核心内容）：

```
agent_docs/
  AGENT.md                # 给智能体的总指令
  docs/                    # 精简文档（场景 → 能力 → 操作）
  skills/                  # 任务型技能拆解
  examples/                # 可运行样例
  outputs/                 # 真实运行输出
  model_configs/           # 模型配置参考
```

---

## 2. Codex（官方规范）

OpenAI Codex 的官方约定是：在项目根目录放置 `AGENTS.md` 作为智能体说明文件。

**建议做法**：
1) 在你的项目根目录创建 `AGENTS.md`。
2) 将 `agent_docs/AGENT.md` 的内容复制进去。
3) 把 `agent_docs/` 放进项目（推荐放到仓库根目录或 `docs/agent_docs/`）。
4) 在 `AGENTS.md` 里注明文档位置，例如：

```text
Agently Docs Pack is at: /agent_docs
Please read /agent_docs/docs/agent-systems/overview.md first.
```

> 说明：Codex CLI 也提供 `codex /init` 生成 `AGENTS.md` 的快捷方式。

---

## 3. Claude Code（官方规范）

Claude Code 会读取项目中的 `CLAUDE.md` 作为记忆与指令文件（支持在子目录放置多个）。

**建议做法**：
1) 在项目根目录创建 `CLAUDE.md`。
2) 将 `agent_docs/AGENT.md` 的内容复制进去。
3) 把 `agent_docs/` 放进项目，并在 `CLAUDE.md` 中标注它的位置。

---

## 4. 放置位置建议（通用）

无论 Codex 还是 Claude Code，**官方要求只有 `AGENTS.md` / `CLAUDE.md`**。其余文档只要在仓库内、且在指令文件里写清路径即可。

推荐结构：

```
<your_repo>/
  AGENTS.md  (Codex)
  CLAUDE.md  (Claude Code)
  agent_docs/
    docs/
    skills/
    examples/
    outputs/
```

---

## 5. 为什么要这样做

- **避免误用**：强制让智能体先读“场景 → 能力 → 操作”路径。
- **避免重复请求**：指导正确使用 `output()` + `instant` + `ensure_keys`。
- **确保交付**：让智能体在每个批次都写测试与预期输出。

如需“人类开发者”视角的 Playbook，请阅读：[Agent 系统 Playbook](/agent-systems/overview)。
