---
title: 核心概念
---

# 核心概念

## Session 是插件容器

`Session` 是一个插件封装，默认实现为 `AgentlyMemoSession`。你可以通过设置切换 Session 插件：

```python
agent.settings.set("plugins.Session.activate", "AgentlyMemoSession")
```

## 三个核心数据结构

- **full_chat_history**：完整对话记录（不裁剪）
- **current_chat_history**：注入 prompt 的当前窗口
- **memo**：稳定偏好、约束与事实的结构化摘要

### 关系示意

```
full_chat_history  --(resize)-->  current_chat_history
         |                              |
         |                              v
         +-----------(memo update)-->  memo
```

## resize 流程

1) **policy** 决定是否 resize，以及是 `lite` 还是 `deep`
2) **handler** 执行裁剪并更新 memo
3) 更新 `current_chat_history` / `memo` / `last_resize` 等信息

> `mode="memo"` 只是启用 memo 更新，不强制 deep；具体由策略决定。

## 什么时候会触发 resize

- `every_n_turns` 达到阈值
- `current_chat_history` 字符数超过 `max_messages_text_length`
- `current_chat_history` 消息数超过 `max_keep_messages_count`
- 手动调用 `session.resize(force="deep")`

## 与 Agent 的关系

`SessionExtension` 负责把 Session 接入 Agent：

- 请求前：把 `current_chat_history` 注入 prompt
- 请求后：把最新消息写入 Session

详见：[Agent 集成](/agent-extensions/session-memo/integration)
