---
title: PRD → 测试用例生成
---

# PRD → 测试用例生成

## 场景

需求评审后，希望快速产出关键测试用例，并能在评审时对齐边界与异常覆盖。

## 方案

- 用 Agent 读 PRD，输出结构化测试用例  
- TriggerFlow 负责流程与复用  
- Output Format 保障字段结构稳定  

```mermaid
flowchart LR
  S[PRD] --> A[Agent 结构化生成]
  A --> R[测试用例结构]
```

## 代码

```python
from agently import Agently, TriggerFlow, TriggerFlowEventData

Agently.set_settings("prompt.add_current_time", False)
Agently.set_settings("OpenAICompatible", {
  "base_url": "http://localhost:11434/v1",
  "model": "qwen2.5:7b",
  "model_type": "chat",
})

agent = Agently.create_agent()

prd = """
功能：手机号验证码登录
- 用户输入手机号，点击获取验证码
- 若手机号不合法，提示错误
- 验证码有效期 5 分钟
- 同一手机号 60 秒内只能请求一次验证码
- 验证码校验通过后登录成功
- 登录成功后跳转首页
""".strip()

flow = TriggerFlow()

@flow.chunk
async def gen_cases(_: TriggerFlowEventData):
  result = await (
    agent
    .input(prd)
    .instruct("基于 PRD 输出 3 条关键测试用例，包含边界与异常。")
    .output({
      "test_cases": [
        {
          "id": ("str", "用例编号"),
          "title": ("str", "用例标题"),
          "priority": ("str", "P0/P1/P2"),
          "type": ("str", "功能/异常/安全"),
          "preconditions": [("str", "前置条件")],
          "steps": [("str", "步骤")],
          "expected": [("str", "预期结果")],
        }
      ],
      "risks": [("str", "潜在风险")],
    })
    .async_start()
  )
  return result

flow.to(gen_cases).end()
result = flow.start("run")
print(result)
```

## 运行结果

```text
{'test_cases': [{'id': 'TC_LOGIN_101', 'title': '输入合法手机号，正常获取验证码并登录', 'priority': 'P1', 'type': '功能', 'preconditions': ['用户有未完成的登录请求', '手机网络可用'], 'steps': ['用户输入正确的手机号码：13800001234', '点击获取验证码', '系统发送短信验证码至正确的手机号'], 'expected': ['验证码发送成功，页面显示发送验证码的提示信息', '验证码窗口有效期为5分钟，不能过期前再次请求', '在有效期内点击验证码按钮会自动填充正确的验证码，并尝试登录验证通过后跳转到首页']}, {'id': 'TC_LOGIN_102', 'title': '输入非法手机号，显示错误提示', 'priority': 'P1', 'type': '异常', 'preconditions': ['系统中已存储正确验证码规则'], 'steps': ['用户输入非法手机号码：133aabbcccde', '点击获取验证码'], 'expected': ['提示框显示错误信息，例如“请输入合法的手机号码”', '验证码发送失败']}, {'id': 'TC_LOGIN_103', 'title': '同一手机号60秒内只能请求一次验证码，超时后可以再次请求', 'priority': 'P2', 'type': '安全', 'preconditions': ['用户发送了两次验证码请求'], 'steps': ['用户输入正确手机号码：13800001234并点击获取验证码', '等待59秒后重复点击获取验证码', '等待超过60秒后再次点击获取验证码'], 'expected': ['首次请求发送验证码成功，提示“5分钟内只能发送一次”或者类似信息', '在60秒内再次请求无法发送新验证码且未过期，则提示“5分钟内只能发送一次”', '等待超过60秒后第二次请求发送验证码成功']}], 'risks': ['如果验证码系统的验证机制失效，可能导致用户绕过验证码直接登录。', '短信频次超出限制可能触发运营商封号或影响用户体验。']}
```
