---
title: 流式返回与事件类型
---

# 流式返回与事件类型

Agently 把模型响应统一成事件流，可同步或异步消费：

- `get_generator(...)`：同步生成器  
- `get_async_generator(...)`：异步生成器  

## 事件类型一览

常见事件如下（以 OpenAICompatible 为例）：

- `delta`：文本增量  
- `reasoning_delta`：思维链增量  
- `tool_calls`：工具调用片段  
- `done`：最终结果文本  
- `original_delta` / `original_done`：原始供应商响应  
- `meta`：usage / finish_reason 等  
- `extra`：扩展字段  
- `error`：请求或解析错误  

## 只拿文本流（delta）

```python
for chunk in response.get_generator(type="delta"):
  print(chunk, end="", flush=True)
```

## 过滤特定事件（specific）

```python
for event, value in response.get_generator(
  type="specific",
  specific=["reasoning_delta", "tool_calls", "done"],
):
  print(event, value)
```

## 读取完整事件流（all）

```python
for event, value in response.get_generator(type="all"):
  print(event, value)
```

## 结构化流式解析（instant / streaming_parse）

当输出为 Agently Output Format 时，可用 `instant` 获取结构化流式事件：

```python
for item in response.get_generator(type="instant"):
  print(item.path, item.delta, item.is_complete)
```

`instant` 与 `streaming_parse` 等价。路径风格由 `response.streaming_parse_path_style` 控制（`dot` 或 `slash`）。

更多细节见：[Instant 结构化流式解析](/output-control/instant-streaming)。
