---
title: 常见模型配置
---

# 常见模型配置

在接入多家模型服务时，我们通常希望配置方式统一、切换成本低。Agently v4 统一使用 **OpenAICompatible**，通过 `base_url + api_key + model` 组合完成模型设置。

## 通用模板

```python
from agently import Agently

Agently.set_settings("OpenAICompatible", {
  "base_url": "https://api.example.com/v1",
  "api_key": "YOUR_API_KEY",
  "model": "your-model-name"
})
```

## 模型索引（总览）

每个模型都有独立配置页，便于跳转申请 Key 与查阅兼容说明：

- 海外： [OpenAI](/models/openai) / [Claude](/models/claude) / [Gemini](/models/gemini) / [Groq](/models/groq)
- 国内： [DeepSeek](/models/deepseek) / [Qwen](/models/qwen) / [文心一言 ERNIE](/models/ernie) / [Kimi](/models/kimi) / [Doubao](/models/doubao) / [MiniMax](/models/minimax) / [GLM](/models/glm)
