---
title: Agently Output Format 语法
---

# Agently Output Format 语法

当你希望模型输出能被程序稳定消费时，通常需要先把结构定义清楚，再让模型填充。Agently Output Format 就是为此设计：结构越清晰，输出越稳定。

## 用结构定义输出

使用 `output()` 定义层级结构，叶子节点用 `(类型, 说明)` 描述。

```python
from agently import Agently

agent = Agently.create_agent()

result = (
  agent
  .input("解释递归，并给出练习题")
  .output({
    "解释": (str, "概念解释"),
    "示例代码": ([(str, "示例代码")], "至少 2 个"),
    "练习题": [
      {
        "题目": (str, "练习题问题"),
        "答案": (str, "参考答案")
      }
    ]
  })
  .start()
)

print(result)
```

## 让结构成为“约束”

`output()` 不只是格式化展示，而是会引导模型按结构生成。结构层级越清楚，模型越容易对齐。

常见写法：

- 标量：`(str, "说明")` / `(int, "说明")` / `(bool, "说明")`
- 列表：`[(str, "说明")]` 或 `[{...}]`
- 嵌套对象：`{ "key": (str, "说明") }`

## 用描述语句锚定语义

描述语句不是注释，而是输出约束的一部分。将“要什么”写清楚，模型稳定性会明显提升。

示例：

```python
.output({
  "定位": (str, "一句话定位"),
  "卖点": [
    {
      "标题": (str, "卖点标题"),
      "说明": (str, "一句话说明")
    }
  ]
})
```

下一步：用 `ensure_keys` 把关键字段“锁”住。
