---
title: 快速开始
---

# 快速开始

本页面面向第一次接触 Agently 的开发者，5 分钟跑通最核心的调用方式。

## 1. 安装

Agently 目前发布在 PyPI，可用 pip 直接安装。

```bash
pip install -U Agently
```

如果你使用 uv 或 pipx，也可以从 PyPI 安装：

```bash
uv pip install -U Agently
```

```bash
pipx install Agently
pipx upgrade Agently
```

## 2. 模型设置

在第一次运行前，建议先配置模型，v4 统一使用 OpenAICompatible。
对于中文开发者而言，您可以选择 DeepSeek 官方 API 进行测试。

```python
from agently import Agently

Agently.set_settings("OpenAICompatible", {
  "base_url": "https://api.deepseek.com/v1",
  "api_key": "YOUR_DEEPSEEK_API_KEY",
  "model": "deepseek-chat"
})
```

常见模型配置速查：见 [常见模型配置](/model-settings)。

## 2.1 Coding Agent 使用（可选）

如果你希望让 Codex / Claude Code 这类 Coding Agent 正确使用 Agently，请下载文档包：

- [/docs/agent_docs.zip](/agent_docs.zip)
- 说明页：[/agent-docs](/agent-docs)

## 3. 最基本的输入输出（结构化）

最短路径：`input()` → `output()` → `start()`。这里用一个分层结构展示 Output Format 的能力。

```python
from agently import Agently

agent = Agently.create_agent()

result = (
  agent
  .input("为 Agently 写一个简短介绍，包含一句话定位与 2 个关键卖点")
  .output({
    "定位": ("str", "一句话定位"),
    "卖点": [
      {
        "标题": ("str", "卖点标题"),
        "说明": ("str", "一句说明")
      }
    ]
  })
  .start()
)

print(result)
```

输出示例：

```text
{
  "定位": "面向生产的 AI 应用开发框架",
  "卖点": [
    { "标题": "结构化输出", "说明": "输出可验证、可迁移" },
    { "标题": "事件编排", "说明": "流程可控、可复现" }
  ]
}
```

## 4. 异步调用

Agently 提供 async API，适合并发调用或 Web 服务。

```python
import asyncio
from agently import Agently

agent = Agently.create_agent()

async def main():
  result = await (
    agent
    .input("列出 3 个 AI 应用的交付难点")
    .output(["str"])
    .async_start()
  )
  print(result)

asyncio.run(main())
```

输出示例：

```text
['输出不可控', '流程难复现', '运维成本高']
```

## 5. 结构化流式输出

Instant 模式支持结构化内容“边生成边消费”，适合对延迟敏感的场景。

```python
from agently import Agently

agent = Agently.create_agent()

response = (
  agent
  .input("用一句话解释什么是递归，并给出 2 个提示")
  .output({
    "definition": ("str", "Short definition"),
    "tips": [("str", "Short tip")]
  })
  .get_response()
)

for msg in response.get_generator(type="instant"):
  if msg.path == "definition" and msg.delta:
    print(msg.delta, end="", flush=True)
  if msg.wildcard_path == "tips[*]" and msg.delta:
    print(msg.delta, end="", flush=True)
print()
```

流式输出片段（示意）：

```text
递归是函数调用自身的过程。
提示1：先定义清晰的终止条件。
提示2：确保问题规模逐步缩小。
```

## 下一步

- 了解模型输出控制与 Agently Output Format
- 了解工程化 Prompt 管理
- 进入 TriggerFlow 事件编排
- 了解配置化 Prompt 与模型热切换
