---
title: if / elif / else 条件分支
---

# if / elif / else 条件分支

当你需要按“优先级顺序”判断时，用 `if / elif / else` 最直观。它等价于 `match().case()` 的“命中优先”模式。

## 场景：按分数分级

```python
from agently import TriggerFlow, TriggerFlowEventData

flow = TriggerFlow()

@flow.chunk
def input_score(_: TriggerFlowEventData):
  return {"score": 82}

@flow.chunk
def grade_a(_: TriggerFlowEventData):
  return "A"

@flow.chunk
def grade_b(_: TriggerFlowEventData):
  return "B"

@flow.chunk
def grade_c(_: TriggerFlowEventData):
  return "C"

@flow.chunk
def print_result(data: TriggerFlowEventData):
  print(data.value)

(
  flow.to(input_score)
  .if_condition(lambda d: d.value["score"] >= 90)
  .to(grade_a)
  .elif_condition(lambda d: d.value["score"] >= 80)
  .to(grade_b)
  .else_condition()
  .to(grade_c)
  .end_condition()
  .to(print_result)
)
flow.start(wait_for_result=False)
```

输出：

```text
B
```

## 场景：嵌套判断（大条件 + 子条件）

```python
from agently import TriggerFlow, TriggerFlowEventData

flow = TriggerFlow()

@flow.chunk
def input_score(_: TriggerFlowEventData):
  return {"score": 95, "vip": False}

@flow.chunk
def to_grade(data: TriggerFlowEventData):
  return {"grade": "A", "vip": data.value["vip"]}

@flow.chunk
def grade_a_plus(_: TriggerFlowEventData):
  return "A+"

@flow.chunk
def grade_a(_: TriggerFlowEventData):
  return "A"

@flow.chunk
def grade_b(_: TriggerFlowEventData):
  return "B"

@flow.chunk
def print_result(data: TriggerFlowEventData):
  print(data.value)

(
  flow.to(input_score)
  .if_condition(lambda d: d.value["score"] >= 90)
  .to(to_grade)
  .if_condition(lambda d: d.value["vip"])
  .to(grade_a_plus)
  .else_condition()
  .to(grade_a)
  .end_condition()
  .else_condition()
  .to(grade_b)
  .end_condition()
  .to(print_result)
)
flow.start(wait_for_result=False)
```

输出：

```text
A
```
