---
title: TriggerFlow 概览
---

# TriggerFlow 概览

在工程里，我们通常希望“信号一到就触发”，而不是等完整流程图静态执行。TriggerFlow 的核心链路是 **when → to → emit**。

## 核心机制：when → to → emit

- **when** 监听/等待信号并开启分支  
- **to** 绑定处理任务并执行  
- **任务完成后（隐式或显式）emit 完成信号**，唤醒下游等待（可以是 `to`，也可以是 `when`）

```mermaid
flowchart LR
  E[emit 信号] --> W[when 监听]
  W --> T[to 绑定处理任务]
  T --> C[处理完成]
  C --> N[emit 完成信号]
  N --> W
```

## 触发类型

TriggerFlow 的信号来源不仅是显式事件，还包括状态变更：

- **event**：`emit()` 产生的事件  
- **runtime_data**：`set_runtime_data()` 触发对应 key 的事件  
- **flow_data**：`set_flow_data()` 触发全局事件（影响所有执行实例）

## 与 Workflow 的差异

- Workflow 更像静态流程图，依赖关系在编译期固定。
- TriggerFlow 是信号系统，连接关系由运行态事件驱动。
- Workflow 关注“流程路径”，TriggerFlow 关注“触发条件 + 状态变化”。

## 最小示例

```python
from agently import TriggerFlow, TriggerFlowEventData

flow = TriggerFlow()

@flow.chunk
async def greet(data: TriggerFlowEventData):
  return f"Hello, {data.value}"

flow.to(greet).end()
result = flow.start("Agently")
print(result)
```

下一步建议阅读：[核心概念](/triggerflow/concepts)。
