---
title: 运行时流式输出
---

# 运行时流式输出

TriggerFlow 支持独立于结果的运行时流：它不改变主信号链，但可以实时输出进度、步骤或状态片段。

## 为什么需要运行时流

AI 结果往往是逐步生成的，用户期待“边生成边看到”。TriggerFlow 内部可能进行了多路编排与并发，但外部体验仍应保持连续、即时的反馈。运行时流的价值就在于：**不暴露内部复杂度，却能把进度与中间片段稳定交付给用户侧**。

```mermaid
flowchart LR
  N[节点执行] --> R[结果 result]
  N --> S[runtime_stream]
  S --> UI[实时 UI/监控]
```

## 生成与消费

```python
from agently import TriggerFlow, TriggerFlowEventData

flow = TriggerFlow()

@flow.chunk
async def stream_steps(data: TriggerFlowEventData):
  data.put_into_stream("step-1")
  data.put_into_stream("step-2")
  data.stop_stream()
  return "done"

flow.to(stream_steps)

for event in flow.get_runtime_stream("start", timeout=None):
  print("[stream]", event)
```

## 关键规则

- `runtime_stream` 与 `result` 相互独立。
- 未调用 `stop_stream()` 会一直等待，需设置 `timeout` 防止阻塞。
