---
name: agently-session-memo
description: Multi-turn memory with Session & Memo. Use when conversations are long, need summarization, or require memory injection.
---

# Agently Session & Memo Skill

Use this skill for **multi-turn context control** and **memo summarization**.

## Core rules
- Enable session via `enable_session_memo(...)` or `attach_session(...)`.
- Memo is **not auto-injected**: explicitly inject with `agent.info({"memo": agent.session.memo})`.
- Keep limits small and test (`chars`, `messages`, `every_n_turns`).

## Patterns
### 1) Enable memo mode
```python
agent.enable_session_memo(chars=800, messages=6, every_n_turns=1)
```

### 2) Inject memo into next turn
```python
agent.info({"memo": agent.session.memo})
reply = agent.input("...").get_text()
```

### 3) Record control (optional)
```python
agent.settings.set("session.record.input.paths", ["input"])
agent.settings.set("session.record.output.paths", ["reply"]) 
```

## Tests (project-level)
- Verify memo updates after each turn.
- Verify memo is actually used in the next response.
- Keep a regression conversation as baseline.

## References
- `docs/agent-extensions/session-memo/quickstart.md`
- `docs/agent-extensions/session-memo/concepts.md`
- `docs/agent-extensions/session-memo/integration.md`
- `docs/context-engineering.md`
- `examples/04_session_memo_dialog.py`
