---
name: agently-triggerflow-orchestration
description: Event-driven orchestration with TriggerFlow. Use for async workflows, concurrency, routing, and runtime streams.
---

# Agently TriggerFlow Orchestration Skill

Use this skill for **signal‑driven workflows**, **routing**, and **parallel execution**.

## Core rules
- `to` is the main chain; `when` is for signal subscriptions.
- Use `if_condition` / `match` for routing.
- Use `for_each` for list processing; `batch` for parallel branches.
- Use runtime stream for progress: `put_into_stream()` + `get_runtime_stream()`.

## Patterns
### 1) Condition + routing
```python
(
  flow.to(step)
  .if_condition(lambda d: d.value["score"] >= 80)
  .to(high)
  .else_condition()
  .to(low)
  .end_condition()
)
```

### 2) Match routing
```python
(
  flow.to(step)
  .match()
  .case("A").to(a)
  .case_else().to(other)
  .end_match()
)
```

### 3) Batch + concurrency
```python
flow.batch(task_a, task_b, concurrency=2).end()
```

## Migration hints
- Dify/LangGraph node → `chunk`
- Edge → `to`
- Router → `match` / `if_condition`
- State → `runtime_data`
- Parallel subgraph → `batch` / `for_each`

## References
- `docs/triggerflow/overview.md`
- `docs/triggerflow/concepts.md`
- `docs/triggerflow/batch.md`
- `docs/triggerflow/concurrency.md`
- `docs/triggerflow/runtime-stream.md`
- `examples/05_triggerflow_orchestration.py`
